<?php
	// MyBB Dynamic Header and Footer plugin code.
	// (C) 2010 CubicleSoft.  All Rights Reserved.
	//
	// This plugin is free to use with the MyBB forum software package.
	// Allows a site header and footer to be dynamically included without modifying the template.
	// Creative Commons License:  http://creativecommons.org/licenses/by-nc-nd/3.0/us
	// Developed by Thomas Hruska, CubicleSoft Core.

	// Disallow direct access to this file for security reasons.
	if (!defined("IN_MYBB"))
	{
		die("Direct initialization of this file is not allowed.<br /><br />Please make sure IN_MYBB is defined.");
	}

	// Admin hooks.
	$plugins->add_hook("admin_config_settings_change", "DynamicHeaderFooter_admin_config_settings");
	$plugins->add_hook("admin_config_settings_start", "DynamicHeaderFooter_admin_config_settings");

	// Global hooks.
	$plugins->add_hook("global_end", "DynamicHeaderFooter_global_end");

	function DynamicHeaderFooter_info()
	{
		global $lang;

		$lang->load("DynamicHeaderFooter_plugin_admin");

		return Array(
			"name" => $lang->DynamicHeaderFooter_plugin_Name,
			"description" => $lang->DynamicHeaderFooter_plugin_Desc,
			"website" => "http://mods.mybboard.net/view/dynamic-header-and-footer",
			"author" => $lang->DynamicHeaderFooter_plugin_Author,
			"authorsite" => "http://www.cubiclesoft.com/",
			"version" => "1.1",
			"guid" => "a8764965c9453459c48b9c45c4785c9f",
			"compatibility" => "14*,16*"
		);
	}

	function DynamicHeaderFooter_install()
	{
		global $mybb, $db, $lang;

		// Delete existing settings (if any).
		$query = $db->simple_select("settinggroups", "gid", "name = 'DynamicHeaderFooter_plugin'");
		$gid = $db->fetch_field($query, "gid");
		if ($gid)  $db->delete_query("settings", "gid = '" . (int)$gid . "'");
		$db->delete_query("settinggroups", "name = 'DynamicHeaderFooter_plugin'");

		// Create new settings group.
		$query = $db->simple_select("settinggroups", "COUNT(*) as rows");
		$numrows = $db->fetch_field($query, "rows");
		$insertarray = Array(
			"name" => "DynamicHeaderFooter_plugin",
			"title" => "Dynamic Header and Footer Configuration",
			"description" => "Sets up the basic options for a dynamic header and footer",
			"disporder" => $numrows + 1,
			"isdefault" => 0
		);
		$db->insert_query("settinggroups", $insertarray);
		$gid = $db->insert_id();

		// Create 'HeaderInclude' setting.
		$insertarray = Array(
			"name" => "DynamicHeaderFooter_HeaderInclude",
			"title" => "Head Tag Include File",
			"description" => $db->escape_string("The include file to use to output to the &lt;head&gt; tag."),
			"optionscode" => "text",
			"value" => "",
			"disporder" => 1,
			"gid" => (int)$gid
		);
		$db->insert_query("settings", $insertarray);

		// Create 'Header' setting.
		$insertarray = Array(
			"name" => "DynamicHeaderFooter_Header",
			"title" => "Header Include File",
			"description" => $db->escape_string("The include file to use to output immediately after the &lt;body&gt; tag."),
			"optionscode" => "text",
			"value" => "",
			"disporder" => 2,
			"gid" => (int)$gid
		);
		$db->insert_query("settings", $insertarray);

		// Create 'RemoveLogo' setting.
		$insertarray = Array(
			"name" => "DynamicHeaderFooter_RemoveLogo",
			"title" => "Remove the Logo",
			"description" => "Remove the logo from the default header.",
			"optionscode" => "yesno",
			"value" => "0",
			"disporder" => 3,
			"gid" => (int)$gid
		);
		$db->insert_query("settings", $insertarray);

		// Create 'Footer' setting.
		$insertarray = Array(
			"name" => "DynamicHeaderFooter_Footer",
			"title" => "Footer Include File",
			"description" => $db->escape_string("The include file to use to output immediately before the &lt;/body&gt; tag."),
			"optionscode" => "text",
			"value" => "",
			"disporder" => 4,
			"gid" => (int)$gid
		);
		$db->insert_query("settings", $insertarray);

		rebuild_settings();
	}

	function DynamicHeaderFooter_is_installed()
	{
		global $db;

		$query = $db->simple_select("settings", "sid", "name = 'DynamicHeaderFooter_HeaderInclude'");
		$sid = $db->fetch_field($query, "sid");
		if ($sid)  return true;

		return false;
	}

	function DynamicHeaderFooter_uninstall()
	{
		global $db;

		// Delete existing settings (if any).
		$query = $db->simple_select("settinggroups", "gid", "name = 'DynamicHeaderFooter_plugin'");
		$gid = $db->fetch_field($query, "gid");
		if ($gid)  $db->delete_query("settings", "gid = '" . (int)$gid . "'");
		$db->delete_query("settinggroups", "name = 'DynamicHeaderFooter_plugin'");

		rebuild_settings();
	}

	function DynamicHeaderFooter_admin_config_settings()
	{
		global $lang;

		$lang->load("DynamicHeaderFooter_plugin_admin");
	}

	// Processes a file/URL.  URLs are not recommended (performance issues) but allowed anyway.
	function DynamicHeaderFooter_Process($file)
	{
		global $lang;

		$file = trim($file);
		if ($file == "")  $data = "";
		else if (strpos($file, "://") !== false)  $data = file_get_contents($file . (strpos($file, "?") === false ? "?" : "&") . "lang=" . urlencode($lang->language) . "&mybb=1");
		else
		{
			ob_start();
			include $file;
			$data = ob_get_contents();
			ob_end_clean();
		}

		return $data;
	}

	function DynamicHeaderFooter_global_end()
	{
		global $mybb, $theme, $lang, $headerinclude, $header, $footer;

		// 'head' tag.
		$headerinclude .= DynamicHeaderFooter_Process($mybb->settings["DynamicHeaderFooter_HeaderInclude"]);

		// Remove logo from original header.
		if ($mybb->settings["DynamicHeaderFooter_RemoveLogo"])
		{
			$findstr = '<div class="logo">';
			$pos = strpos($header, $findstr);
			if ($pos !== false)
			{
				$pos2 = strpos($header, '</div>', $pos + strlen($findstr));
				if ($pos2 !== false)  $header = substr($header, 0, $pos) . substr($header, $pos2 + 6);
			}
		}

		// Remove header items that are not in use/inaccessible (cleans up clutter).
		if ($mybb->settings["enablememberlist"] == 0)
		{
			$findstr = '<li><a href="' . $mybb->settings["bburl"] . '/memberlist.php"><img src="' . $mybb->settings["bburl"] . '/' . $theme["imgdir"] . '/toplinks/memberlist.gif" alt="" title="" />' . $lang->toplinks_memberlist . '</a></li>';
			$header = str_replace($findstr, "", $header);
			$findstr = '<li><a href="' . $mybb->settings["bburl"] . '/memberlist.php"><img src="' . $theme["imgdir"] . '/toplinks/memberlist.gif" alt="" title="" />' . $lang->toplinks_memberlist . '</a></li>';
			$header = str_replace($findstr, "", $header);
		}

		if ($mybb->settings["enablecalendar"] == 0)
		{
			$findstr = '<li><a href="' . $mybb->settings["bburl"] . '/calendar.php"><img src="' . $mybb->settings["bburl"] . '/' . $theme["imgdir"] . '/toplinks/calendar.gif" alt="" title="" />' . $lang->toplinks_calendar . '</a></li>';
			$header = str_replace($findstr, "", $header);
			$findstr = '<li><a href="' . $mybb->settings["bburl"] . '/calendar.php"><img src="' . $theme["imgdir"] . '/toplinks/calendar.gif" alt="" title="" />' . $lang->toplinks_calendar . '</a></li>';
			$header = str_replace($findstr, "", $header);
		}

		// Header at the start of 'body' tag.
		$header = DynamicHeaderFooter_Process($mybb->settings["DynamicHeaderFooter_Header"]) . $header;

		// Remove footer items that are not in use (usually already located in the dynamic header/footer, so these are clutter).
		if ($mybb->settings["contactlink"] == "")
		{
			$findstr = '<a href="">' . $lang->bottomlinks_contactus . '</a> | ';
			$footer = str_replace($findstr, "", $footer);
		}

		if ($mybb->settings["homeurl"] == "" || $mybb->settings["homename"] == "")
		{
			$findstr = '<a href="' . $mybb->settings["homeurl"] . '">' . $mybb->settings["homename"] . '</a> | ';
			$footer = str_replace($findstr, "", $footer);
		}

		// Footer before the closing '/body' tag.
		$footer .= DynamicHeaderFooter_Process($mybb->settings["DynamicHeaderFooter_Footer"]);
	}
?>